{capture "combinationTemplate"}
    <div class="combination mb-4">
    {foreach $attributes AS $attr_group_id => $attribut}
    <div class="row">
        <div class="col-xs-6">
            {$attribut[0]['public_name']}
        </div>
        <div class="col-xs-6">
            <select name=attributes[0][] {if $attribut[0]['public_name']=='Kolor'}attribute="color"{/if}>
                <option value=0>Wybierz</option>
                {foreach $attribut AS $item}
                    <option value="{$item['id_attribute']}">
                        {$item['name']}
                    </option>
                {/foreach}
            </select>
        </div>
    </div>
    {/foreach} 
    <input name="attributes[0][symbol]" value="" hidden>                       
    <input name="attributes[0][cover]" value="" hidden>                       
    <div class="custom-btn removeCombination">usuń</div>
    </div>
{/capture}


{capture "featureTemplate"}
    <div class="row feature">
        <div class="col-xs-5">
            <select name=features[0][feature_id] type="feature">
                <option value=0>Wybierz</option>
                {foreach $features AS $feature}
                <option value="{$feature['id_feature']}">
                    {$feature['name']}
                </option>
                {/foreach}
            </select>
        </div>
        <div class="col-xs-5">
            <select name=features[0][value_id][] type="value" multiple>
                {* <option value=0>Wybierz</option> *}

            </select>
        </div>
        <div class="col-xs-2">
        <div class="custom-btn removeFeature">usuń</div>
        </div>
    </div>
{/capture}



<style>
    ul {
        list-style-type: none;
    }

    li {
        display: inline-block;
    }

    input[type="checkbox"][id^="cbIMG"] {
        display: none;
    }

    .checkbox-tick label {
        border: 1px solid #fff;
        padding: 10px;
        display: block;
        position: relative;
        margin: 10px;
        cursor: pointer;
    }

    .checkbox-tick label:before {
        background-color: white;
        color: white;
        content: " ";
        display: block;
        border-radius: 50%;
        border: 1px solid grey;
        position: absolute;
        top: -5px;
        left: -5px;
        width: 25px;
        height: 25px;
        text-align: center;
        line-height: 28px;
        transition-duration: 0.4s;
        transform: scale(0);
    }

    .checkbox-tick label img {
        height: 100px;
        width: 100px;
        transition-duration: 0.2s;
        transform-origin: 50% 50%;
    }

    .checkbox-tick :checked+label {
        border-color: #ddd;
    }

    .checkbox-tick :checked+label:before {
        content: "✓";
        background-color: grey;
        transform: scale(1);
    }

    .mb-4 {
        margin-bottom: 15px;
    }
    .custom-btn {
            color: #fff;
            background: #ff5b00;
            letter-spacing: 2px;
            font-weight: 500;
            text-transform: uppercase;
            border: 0;
            text-align: center;
            padding: 10px;
        }

    .custom-btn:hover {
        background: #fc7b33;
        cursor:pointer;
    }
</style>

<div class="panel">
    <div class="row">
        <div class="tab-content col-md-12">
            <form action="" method="post" enctype="multipart/form-data" novalidate="" autocomplete="off">
                {foreach $idArray->description AS $key => $description}
                    <input name="checkedIDs[]" value="{$key}" hidden>   
                {/foreach}
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="control-label col-lg-2">
                                {l s='Wybierz tytuł' mod='psoft_allegro'}
                            </label>
                            <div class="col-lg-6">
                            {$titleitems = array_keys(get_object_vars($idArray->title))}
                                <input list="titleList" name="title" type="text" value="{$idArray->title->$titleitems[0]}">
                                <datalist id="titleList">
                                    {foreach $idArray->title AS $title}
                                        <option value="{$title}">
                                    {/foreach}
                                </datalist>
                                <p class="help-block">
                                    {l s='Poprzez podwójne kliknięcie możesz wyświetlić listę dostępnych nazw produktów. W każdej chwili możesz utworzyć dowolny tytuł produktu.' mod='psoft_allegro'}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="control-label col-lg-2">
                                {l s='Ilość' mod='psoft_allegro'}
                            </label>
                            <div class="col-lg-6">
                                <select name='qty'>
                                    {foreach $idArray->qty AS $qty}
                                        <option value="{$qty}">{$qty}</option>
                                    {/foreach}
                                </select>
                                <p class="help-block">
                                    {l s='' mod='psoft_allegro'}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="control-label col-lg-2">
                                {l s='Cena' mod='psoft_allegro'}
                            </label>
                            <div class="col-lg-6">
                                <select name='price'>
                                    {foreach $idArray->price AS $price}
                                        <option value="{$price}">{$price}</option>
                                    {/foreach}
                                </select>
                                <p class="help-block">
                                    {l s='' mod='psoft_allegro'}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                {$categoryKey = array_keys(get_object_vars($idArray->categoryID))}
                <input type='hidden' name='categoryID' value="{$idArray->categoryID->$categoryKey[0]}"/>
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="control-label col-lg-2">
                                {l s='Indeks' mod='psoft_allegro'}
                            </label>
                            <div class="col-lg-6">
                                <select name='symbol'>
                                    {foreach $idArray->symbol AS $symbol}
                                        <option value="{$symbol}">{$symbol}</option>
                                    {/foreach}
                                </select>
                                <p class="help-block">
                                    {l s='' mod='psoft_allegro'}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>               


                <div class="row">
                    <div class="col-12 ">
                        <label >Wybierz opis:</label>
                            {$first=true}
                            {foreach $idArray->description AS $key => $description}
                            <div class="row">
                                <div class="col-12 checkbox-tick">
                                    <input id="{$key}" type='radio' value="{$description}" name='description' style="display: none;" {if $first}checked{/if}>
                                    <label for="{$key}">{$description}</label>
                                </div>
                            </div>
                            {$first=false}
                            {/foreach}
                        
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <label>Wybierz zdjęcia: </label>
                            <ul>
                                {if $combinationExist}
                                    {foreach $idArray->images AS $uctionID => $images}
                                    {foreach $images AS $key => $image}
                                    <li class="checkbox-tick">
                                        <input type="checkbox" id="cbIMG_{$uctionID}_{$key}" name="image[]" value="{$image}" checked/>
                                        <label for="cbIMG_{$uctionID}_{$key}" ><img src="{$image}" /></label>
                                    </li>
                                    {/foreach}
                                    {/foreach}
                                {else}
                                    {$count=0}
                                    {$checkedKey}
                                    {foreach $idArray->images AS $uctionID => $images}
                                    {if count($images) > $count}{$count=count($images)}{$checkedKey=$uctionID}{/if}
                                    {/foreach}

                                    {foreach $idArray->images AS $uctionID => $images}
                                    {foreach $images AS $key => $image}
                                    <li class="checkbox-tick">
                                        <input type="checkbox" id="cbIMG_{$uctionID}_{$key}" name="image[]" value="{$image}" {if $uctionID===$checkedKey}checked{/if}/>
                                        <label for="cbIMG_{$uctionID}_{$key}"><img src="{$image}" /></label>
                                    </li>
                                    {/foreach}
                                    {/foreach}
                                {/if}
                            </ul>
                       
                    </div>
                </div>

                
                {if $features}
                    <div id="addFeatureBtn" class="custom-btn" >Dodaj cechę</div>
                    <div class="features-list">                    
                    </div>                        
                {/if}

                {if $attributes}
                    <div id="addCombinationBtn" class="custom-btn" >Dodaj kombinację</div>
                    <div class="combination-list">                    
                    </div>
                {/if}
                

                <button type='submit' class="allegro-btn" name='createProduct'>Stwórz product</button>
            </form>
           
        </div>
    </div>
</div>

<script>
    const featureTemplate = $('{preg_replace('/\s+/', ' ', trim($smarty.capture.featureTemplate))}');
    const combinationTemplate = $('{preg_replace('/\s+/', ' ', trim($smarty.capture.combinationTemplate))}');
    const featuresData = {$featuresJSON};
    const colors = JSON.parse('{json_encode($idArray->color)}');
    const colorsUnique = [];
    const modelsFeatureID = featuresData.find(featureGroup=>featureGroup.name==="Model");
    const modelsList = JSON.parse('{json_encode($idArray->modelList)}')
    {* colors.forEach(item=>{
        item.color.forEach(color=>{
            colorsUnique.push({
                color:color,
                symbol:item.symbol,
                cover:item.cover
            })

        })
    }) *}


    colors.forEach(colorUniq=>createCombinationColor(colorUniq.color,colorUniq.symbol,colorUniq.cover));
    modelsList.forEach(model=>{
        if(modelsFeatureID && model.value_id){
            createModelFeatureList(model.value_id,modelsFeatureID.id_feature);
        }
    })
    $('#addFeatureBtn').click(function(){
        const count = $('.feature').length;
        const newFeature = featureTemplate.clone();
        newFeature.find('[type="feature"]').attr('name','features['+count+'][feature_id]');
        newFeature.find('[type="value"]').attr('name','features['+count+'][value_id][]');
        const multiselect = tail.select(newFeature[0].querySelector('[type="value"]'),
        {
            search:true,
        });
        newFeature.find('[type="feature"]').change(function (e){
            newFeature.find('[type="value"] option').remove();
            const values = featuresData.filter(item=>item.id_feature===e.target.value);
            if(values.length){
                values[0].info.forEach(value=>{
                    newFeature.find('[type="value"]').append('<option value="'+value.id_feature_value+'" >'+value.value+'</option>');

            })
            multiselect.reload();
            }

             
        })
        
        newFeature.find('.removeFeature').click(function(){
            newFeature.remove()
        })
        newFeature.appendTo($('.features-list'));
    })

    $('#addCombinationBtn').click(function(e){
        const count = $('.combination').length;
        const newCombination = combinationTemplate.clone();
        newCombination.find('select').attr('name','attributes['+count+'][]');
        newCombination.find('[name$="][symbol]"]').attr('name','attributes['+count+'][symbol]')
        newCombination.find('[name$="][cover]"]').attr('name','attributes['+count+'][cover]')
        newCombination.appendTo($('.combination-list'));
        newCombination.find('.removeCombination').click(function(f){
            newCombination.remove();
        })
    })

function createCombinationColor(color, symbol,cover){
    const count = $('.combination').length;
    let found = false;
    const newCombination = combinationTemplate.clone();
    newCombination.find('select').attr('name','attributes['+count+'][]');
    newCombination.find('[attribute="color"]').children().each(function(){
        {* console.log('"'+$(this).text().toLowerCase()+'"'); *}
        if($(this).text().toLowerCase().replace(/\s/g, "") === color.toLowerCase()){
            $(this).attr('selected', true);
            newCombination.find('[name$="][symbol]"]').attr('name','attributes['+count+'][symbol]').val(symbol);
            newCombination.find('[name$="][cover]"]').attr('name','attributes['+count+'][cover]').val(cover);
            found = true;
        }        
    })
    if(found){
        newCombination.appendTo($('.combination-list'));
        newCombination.find('.removeCombination').click(function(f){
            newCombination.remove();
        })
    }

}
    function createModelFeatureList(models,feature_id){
        const count = $('.feature').length;
        const newFeature = featureTemplate.clone();
        newFeature.find('[type="feature"]').attr('name','features['+count+'][feature_id]');
        newFeature.find('[type="value"]').attr('name','features['+count+'][value_id][]');
        const multiselect = tail.select(newFeature[0].querySelector('[type="value"]'),
        {
            search:true,
        });
        newFeature.find('[type="feature"]').change(function (e){
            newFeature.find('[type="value"] option').remove();
            const values = featuresData.filter(item=>item.id_feature===e.target.value);
            if(values.length){
                values[0].info.forEach(value=>{
                    newFeature.find('[type="value"]').append('<option value="'+value.id_feature_value+'" >'+value.value+'</option>');

            })
            multiselect.reload();
            }             
        })
        
        newFeature.find('.removeFeature').click(function(){
            newFeature.remove()
        })
        newFeature.find('[type="feature"]').val(feature_id).change();
        newFeature.find('[type="value"]').val(models);
        multiselect.reload();
        newFeature.appendTo($('.features-list'));
    }

</script>
