<?php
    require_once(dirname(__FILE__).'/../../../config/config.inc.php');
    require_once(dirname(__FILE__) . '/../core/psoftAllegroCore.php');

    $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
    $idShop = (int)Context::getContext()->shop->id;
    $env = new psoftAllegroCore();
    $setEnv = $env->setEnvironment();

    $authUrl = $setEnv->auth . "/token?grant_type=authorization_code&code=".$_GET['code'].'&redirect_uri='._PS_BASE_URL_SSL_.'/modules/psoft_allegro/oAuth/code.php';
    $ch = curl_init($authUrl);

    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Basic ".base64_encode(Configuration::get('PSOFT_ALLEGRO_CLIENT_ID', $idLang = null, $idShopGroup, $idShop, $default = false).':'.Configuration::get('PSOFT_ALLEGRO_CLIENT_SECRET', $idLang = null, $idShopGroup, $idShop, $default = false)),
    ]);
    $tokenResult = curl_exec($ch);
    $resultCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    $tokenObject = json_decode($tokenResult);

    if ($tokenResult === false || $resultCode !== 200) {
        echo "Something went wrong - oAuth</br>";
        //echo $tokenResult->errors[0]->userMessage;
		echo $tokenResult;
    } else {
        Configuration::updateValue('PSOFT_ALLEGRO_ACCESS_TOKEN', $tokenObject->access_token, $html = false, $idShopGroup, $idShop);
        Configuration::updateValue('PSOFT_ALLEGRO_REFRESH_TOKEN', $tokenObject->refresh_token, $html = false, $idShopGroup, $idShop);
        $url =  Configuration::get('PSOFT_ALLEGRO_RETURN_URL', $idLang = null, $idShopGroup, $idShop, $default = false);
        header('Location:'.$url);
        die();
    }
