<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */

class psoftAllegroLogController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = true;
        $this->allow_export = false;
        parent::__construct();
    }

    public function init()
    {
        parent::init();
    }

    public function initContent()
    {
        $this->display = 'view';
        parent::initContent();
    }

    public function renderView()
    {
        if (Tools::isSubmit('selLog')) {
            $selFiles = Tools::getValue('log');

            $this->context->smarty->assign(array(
                'file' => strip_tags(nl2br(file_get_contents(dirname(__FILE__) . '/../../log/' . $selFiles)))
            ));
        } else {
            $this->context->smarty->assign(array(
                'file' => strip_tags(nl2br(file_get_contents(dirname(__FILE__) . '/../../log/' . date("Y-m-d") . '.log'))),
            ));
        }

        $this->context->smarty->assign(array(
            'dir' => preg_grep('~\.(log)$~', scandir('../modules/psoft_allegro/log')),
        ));
        return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'psoft_allegro/views/templates/admin/log.tpl');
    }
}
