<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */

require_once(dirname(__FILE__) . '/../../core/psoftAllegroCore.php');

include_once(_PS_ROOT_DIR_.'/classes/log/FileLogger.php');

class psoftAllegroConfigurationController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = true;
        $this->allow_export = false;
        $this->log = new FileLogger();
        $this->log->setFilename(_PS_MODULE_DIR_ . '/psoft_allegro/log/' . date("Y-m-d") . '.log');
        $this->psoftAllegroCore = new psoftAllegroCore();
        parent::__construct();
    }

    public function init()
    {
        parent::init();
    }

    public function initContent()
    {
        $this->display = 'view';
        parent::initContent();
    }

    public function renderView()
    {
        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        if (Tools::isSubmit('setLicense')) {
            Configuration::updateValue('PSOFT_ALLEGRO_LICENSE_ID', Tools::getValue('license'), $html = false, $idShopGroup, $idShop);
        }

        if (Tools::isSubmit('setAllegroSecret')) {
            $getEnvironment = Configuration::get('PSOFT_ALLEGRO_SELECTED_ENVIRONMENT', $idLang = null, $idShopGroup, $idShop, $default = false);
            if ($getEnvironment != Tools::getValue('block_option_2')) {
                Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_ID', '', $html = false, $idShopGroup, $idShop);
                Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_SECRET', '', $html = false, $idShopGroup, $idShop);
                $this->psoftAllegroCore->logOut();
            }
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_ENVIRONMENT', Tools::getValue('block_option_2'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_ID', Tools::getValue('clientId'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_SECRET', Tools::getValue('clientSecret'), $html = false, $idShopGroup, $idShop);
        }
        if (Tools::isSubmit('getToken')) {
            $this->psoftAllegroCore->getAccessOAuthToken();
        }
        if (Tools::isSubmit('importOffers')) {
            $bool = $this->psoftAllegroCore->importOffers(Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
            if ($bool) {
                $this->psoftAllegroCore->importCategories(Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
            }
        }
        if (Tools::isSubmit('refreshToken')) {
            $this->psoftAllegroCore->refreshToken();
        }
        if (Tools::isSubmit('logOutAllegro')) {
            $this->psoftAllegroCore->logOut();
        }

        if (Tools::isSubmit('setAllegroSettings')) {
            Configuration::updateValue('PSOFT_ALLEGRO_GROUP_PRODUCTS', Tools::getValue('block_option_1'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_FEATURESIZE', Tools::getValue('featureSize'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_DESCRIPTION', Tools::getValue('description'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_CATEGORIES', Tools::getValue('categoriesShop'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_COLOR', Tools::getValue('colorsShop'), $html = false, $idShopGroup, $idShop);
        }

        return $this->renderForm();
    }

    public function renderForm()
    {

        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        $clientId = Configuration::get('PSOFT_ALLEGRO_CLIENT_ID', $idLang = null, $idShopGroup, $idShop, $default = false);
        $clientSecret = Configuration::get('PSOFT_ALLEGRO_CLIENT_SECRET', $idLang = null, $idShopGroup, $idShop, $default = false);
        $offers = json_decode(Configuration::get('PSOFT_ALLEGRO_OFFERS', $idLang = null, $idShopGroup, $idShop, $default = false));
        $this->context->smarty->assign(array(
            'license' => Configuration::get('PSOFT_ALLEGRO_LICENSE_ID', $idLang = null, $idShopGroup, $idShop, $default = false),
            'access_token' => Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false),
            'refresh_token' => Configuration::get('PSOFT_ALLEGRO_REFRESH_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false),
            'mapCategoriesList' => json_decode($this->psoftAllegroCore->getConfiguration("MAP_CATEGORIES")),
            'clientId' => $clientId ? $clientId : false,
            'clientSecret' => $clientSecret ? $clientSecret : false,
            'groupProductsBy' => Configuration::get('PSOFT_ALLEGRO_GROUP_PRODUCTS', $idLang = null, $idShopGroup, $idShop, $default = false),
            'featureSize' => Configuration::get('PSOFT_ALLEGRO_FEATURESIZE', $idLang = null, $idShopGroup, $idShop, $default = false),
            'description' => Configuration::get('PSOFT_ALLEGRO_DESCRIPTION', $idLang = null, $idShopGroup, $idShop, $default = false),
            'getCategoriesShop' => $this->psoftAllegroCore->getCategoryList(),
            'selectedCategoriesShop' => Configuration::get('PSOFT_ALLEGRO_SELECTED_CATEGORIES', $idLang = null, $idShopGroup, $idShop, $default = false),
            'getAllColors' => $this->psoftAllegroCore->getAllColors(),
            'selectedColor' => Configuration::get('PSOFT_ALLEGRO_SELECTED_COLOR', $idLang = null, $idShopGroup, $idShop, $default = false),
            'selectedEnvironment' => Configuration::get('PSOFT_ALLEGRO_SELECTED_ENVIRONMENT', $idLang = null, $idShopGroup, $idShop, $default = false),
            'cronImport' => _PS_BASE_URL_SSL_ . _MODULE_DIR_ . 'psoft_allegro/cron.php?action=import&token=' . substr(Tools::encrypt('psoft_allegro'), 0, 10),
            'cronUpdate' => _PS_BASE_URL_SSL_ . _MODULE_DIR_ . 'psoft_allegro/cron.php?action=update&token=' . substr(Tools::encrypt('psoft_allegro'), 0, 10),
        ));
        $this->log->logInfo("Auction list displayed");
        return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'psoft_allegro/views/templates/admin/configuration.tpl');
    }
}
