<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */

require_once(dirname(__FILE__) . '/../../core/psoftAllegroCore.php');

class psoftAllegroCatController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = true;
        $this->allow_export = false;
        $this->psoftAllegroCore = new psoftAllegroCore();
        parent::__construct();
    }

    public function init()
    {
        parent::init();
        $psoftAllegroCore = new psoftAllegroCore();

        if (Tools::isSubmit('saveCategoriesMap')) {
            $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
            $idShop = (int)Context::getContext()->shop->id;

            $psoftAllegroCore->mapCategories(Tools::getValue('categoryID'));
            $psoftAllegroCore->getMapCategories();
        }

        if (Tools::isSubmit('exportCategories')) {
            $psoftAllegroCore->exportCategories();
        }

        if (Tools::isSubmit('importCategories') && $_FILES["fileToUpload"]["tmp_name"]) {
            $psoftAllegroCore->importCategoriesFile($_FILES["fileToUpload"]);
        }
    }

    public function initContent()
    {
        $this->display = 'view';
        parent::initContent();
    }

    public function renderView()
    {
        return $this->renderForm();
    }

    public function renderForm()
    {
        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        $notifications = $this->psoftAllegroCore->displayNotifications($skip = 'cat');
        if ($notifications) {
            return $notifications;
        }

        $content = json_encode($this->psoftAllegroCore->getMapCategories());

        $this->context->smarty->assign(array(
            'mapCategoriesList' => json_decode($content),
        ));
        return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'psoft_allegro/views/templates/admin/categories.tpl');
    }
}
