<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */

require_once(dirname(__FILE__) . '/../../core/psoftAllegroCore.php');

include_once(_PS_ROOT_DIR_.'/classes/log/FileLogger.php');

class psoftAllegroAuctionsController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = true;
        $this->allow_export = false;
        $this->log = new FileLogger();
        $this->log->setFilename(_PS_MODULE_DIR_ . '/psoft_allegro/log/'. date("Y-m-d") .'.log');
        $this->psoftAllegroCore = new psoftAllegroCore();
        parent::__construct();
    }

    public function init()
    {
        parent::init();
    }

    public function initContent()
    {
        $this->display = 'view';
        parent::initContent();
    }

    public function renderView()
    {
        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        if (Tools::isSubmit('setAllegroSecret')) {
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_ID', Tools::getValue('clientId'), $html = false, $idShopGroup, $idShop);
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_SECRET', Tools::getValue('clientSecret'), $html = false, $idShopGroup, $idShop);
        }
        if (Tools::isSubmit('getToken')) {
            $this->psoftAllegroCore->getAccessOAuthToken();
        }
        if (Tools::isSubmit('importOffers')) {
            $bool = $this->psoftAllegroCore->importOffers(Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
            if ($bool) {
                $this->psoftAllegroCore->importCategories(Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
            }
        }
        if (Tools::isSubmit('refreshToken')) {
            $this->psoftAllegroCore->refreshToken();
        }
        if (Tools::isSubmit('logOutAllegro')) {
            $this->psoftAllegroCore->logOut();
        }
        if (Tools::isSubmit('importCategories')) {
            $this->psoftAllegroCore->importCategories(Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
        }
        if (Tools::isSubmit('autoCreateProduct')) {
            $checkedIDlist = Tools::getValue('checked_auction');
            $this->psoftAllegroCore->autoCreateProduct($checkedIDlist, Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
        }
        if (Tools::isSubmit('createProduct_step_1')) {
            Configuration::updateValue('PSOFT_ALLEGRO_OFFERS', '', $html = false, $idShopGroup, $idShop);
            $checkedIDlist = Tools::getValue('checked_auction');
            $productData = $this->psoftAllegroCore->getProductData($checkedIDlist, Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false));
            Configuration::updateValue('PSOFT_ALLEGRO_ID_TO_CREATE', json_encode($productData), $html = false, $idShopGroup, $idShop);
            return $this->renderForm('createProduct_step_1');
        }
        if (Tools::isSubmit('createProduct')) {
            $productData =  new stdClass();
            $productData->title = Tools::getValue('title');
            $productData->description = Tools::getValue('description');
            $productData->images = Tools::getValue('image');
            $productData->categoryID = Tools::getValue('categoryID');
            $productData->symbol = Tools::getValue('symbol');
            $productData->price = Tools::getValue('price');
            $productData->qty = Tools::getValue('qty');
            $productData->attributes = Tools::getValue('attributes');
            $productData->features = Tools::getValue('features');
            $productData->checkedIDs = Tools::getValue('checkedIDs');
            $this->psoftAllegroCore->createProduct($productData);
            Configuration::updateValue('PSOFT_ALLEGRO_ID_TO_CREATE', '', $html = false, $idShopGroup, $idShop);
        }
        if (Tools::isSubmit('removeSkipProduct')) {
            $this->psoftAllegroCore->removeSkipProduct(Tools::getValue('removeSkipProduct'));
        }
        if (Tools::isSubmit('skipProducts')) {
            $this->psoftAllegroCore->skipProducts(Tools::getValue('checked_auction'));
        }
        if (Tools::isSubmit('searchAuctions')) {
            $newUrl = $this->psoftAllegroCore->setPageParam($_SERVER['REQUEST_URI'], Tools::getValue('filter-query'));
            Tools::redirectAdmin($newUrl . '&page=1');
        }

        Configuration::updateValue('PSOFT_ALLEGRO_OFFERS', json_encode($this->psoftAllegroCore->getOffers((int) Tools::getValue('page', 1), ['symbol' => Tools::getValue('symbol', ''), Tools::getValue('skip') ? 'skip' : null, Tools::getValue('new') ? 'new' : null, Tools::getValue('imported') ? 'imported' : null])), $html = false, $idShopGroup, $idShop);
        return $this->renderForm();
    }

    public function renderForm($form = 'default')
    {
        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        $this->psoftAllegroCore->getFeatures();
        switch ($form) {
            case 'createProduct_step_1':
                $attributes = $this->psoftAllegroCore->getAttributesList();
                $features = $this->psoftAllegroCore->getFeatures();
                $productData = json_decode(Configuration::get('PSOFT_ALLEGRO_ID_TO_CREATE', $idLang = null, $idShopGroup, $idShop, $default = false));
                if (!isset($productData->color)) {
                    $productData->color = [];
                }
                $combinationExist = false;
                foreach ($productData->symbol as $symbol) {
                    if (strpos($symbol, '-') !== false) {
                        $combinationExist = true;
                    }
                }
                $this->context->smarty->assign(array(
                    'idArray' => $productData,
                    'combinationExist' => $combinationExist,
                    'attributes' => $attributes ? $attributes : false,
                    'features' => $features ? $features : false,
                    'featuresJSON' => $features ? json_encode($features) : false,
                ));
                return $this->display(__FILE__, 'views/templates/admin/createProduct.tpl');

            default:
                $notifications = $this->psoftAllegroCore->displayNotifications($skip = '');
                if($notifications)
                {
                    return $notifications;
                }
                $env = $this->psoftAllegroCore->setEnvironment();
                $clientId = Configuration::get('PSOFT_ALLEGRO_CLIENT_ID', $idLang = null, $idShopGroup, $idShop, $default = false);
                $clientSecret = Configuration::get('PSOFT_ALLEGRO_CLIENT_SECRET', $idLang = null, $idShopGroup, $idShop, $default = false);
                $offers = json_decode(Configuration::get('PSOFT_ALLEGRO_OFFERS', $idLang = null, $idShopGroup, $idShop, $default = false));
                $this->context->smarty->assign(array(
                    'access_token' => Configuration::get('PSOFT_ALLEGRO_ACCESS_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false),
                    'refresh_token' => Configuration::get('PSOFT_ALLEGRO_REFRESH_TOKEN', $idLang = null, $idShopGroup, $idShop, $default = false),
                    'offers' => $offers->offers,
                    'countPage' => $offers->count,
                    'mapCategoriesList' => json_decode($this->psoftAllegroCore->getConfiguration("MAP_CATEGORIES")),
                    'clientId' => $clientId ? $clientId : false,
                    'clientSecret' => $clientSecret ? $clientSecret : false,
                    'customUrl' => $this->psoftAllegroCore->setPageParam($_SERVER['REQUEST_URI'], get_object_vars($offers->filter)),
                    'filter' => get_object_vars($offers->filter),
                    'search' => Tools::getValue('symbol'),
                    'selectedPage' => Tools::getValue('page'),
                    'envURL' => $env->url
                ));
                $this->log->logInfo("Auction list displayed");
                return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'psoft_allegro/views/templates/admin/auctions.tpl');
        }
    }
}
