{*
/**
*
* @author PSoft - Przemysław Suszek <kontakt@suszek.info>
    * @copyright PSoft - Przemysław Suszek
    * @license This program is not free software and you can't resell and redistribute it
    * @category PrestaShop Module
    *
    */
    *}
    <style>
        .w100{
            width:100%;
            display:inline;
        }
        .mb-4 {
            margin-bottom: 15px;
        }

        .allegro-btn {
            color: #fff;
            background: #ff5a00;
            letter-spacing: 2px;
            font-weight: 500;
            text-transform: uppercase;
            border: 0;
            text-align: center;
            padding: 10px;
        }

        .allegro-btn:hover {
            background: #ff7b33;
        }

        .allegro-button-row{
            display:flex;
        }

        .allegro-button-row button{
            margin:5px 5px 5px 0px;
        }
    </style>
    <div class="panel">
        <div class="row">
            {if !$access_token || !$clientId || !$clientSecret}
                <div class="alert alert-info">
                    {l s='Przed pierwszym użyciem należy skonfigurować moduł. W tym celu proszę zapoznać się z instrukcją obsługi, która dostępna jest po lewej stronie.' mod='psoft_allegro'}
                </div>
            {/if}
            {if is_object($mapCategoriesList)}
                {if $mapCategoriesList->done == ''}
                    <div class="alert alert-info">
                        {l s='Proszę powiązać kategorię.' mod='psoft_allegro'}
                    </div>
                {/if}
            {/if}
            <ul class="nav nav-pills nav-stacked col-md-2">
                <li class="active"><a href="#main-tab" data-toggle="pill">{l s='Konfiguracja' mod='psoft_allegro'}</a></li>
                <li><a href="#author" data-toggle="pill">{l s='Author' mod='psoft_allegro'}</a></li>
            </ul>
            <div class="tab-content col-md-10">
                <div class="tab-pane active" id="main-tab">
                    <div class="tab-content">
                        <form id="module_form" class="defaultForm form-horizontal" action="" method="post" enctype="multipart/form-data" novalidate="">
                            <div class="panel">
                                <div class="panel-heading">{l s='Licencja' mod='psoft_allegro'}</div>                          
                                <div class="form-group">                                   
                                    <label class="control-label col-lg-3">
                                        {l s='Licencja' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-6">
                                        <input value="{$license}" name="license" type="text">
                                        <p class="help-block"></p>
                                    </div>
                                </div>
                                <div class="panel-footer">
                                    <button type="submit" value="1" id="module_form_submit_btn" name="setLicense" class="btn btn-default pull-right">
                                        <i class="process-icon-save"></i>{l s='Save' mod='psoft_allegro'}
                                    </button>
                                </div>
                            </div>
                        </form>
                        <form id="module_form" class="defaultForm form-horizontal" action="" method="post" enctype="multipart/form-data" novalidate="">
                            <div class="panel">
                                <div class="panel-heading">{l s='Konfiguracja' mod='psoft_allegro'}</div>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                            {l s='Włącz środowisko testowe' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-9">
                                        <span class="switch prestashop-switch fixed-width-lg">
                                            <input name="block_option_2" id="block_option_2_on" value="1" {if $selectedEnvironment == '1'}checked="checked"{/if} type="radio">
                                            <label for="block_option_2_on">{l s='Tak' mod='psoft_allegro'}</label>
                                            <input name="block_option_2" id="block_option_2_off" value="0" {if $selectedEnvironment == '0'}checked="checked"{/if} type="radio">
                                            <label for="block_option_2_off">{l s='Nie' mod='psoft_allegro'}</label>
                                            <a class="slide-button btn"></a>
                                        </span>
                                        <p class="help-block">{l s='Zmiana opcji spowoduje rozłączenie powiązania pomiędzy sklepem a platformą Allegro. Wiąże się rónież z wprowadzeniem nowych Client ID / klucz WebAPI oraz Client secret.' mod='psoft_allegro'}                                               
                                    </p>
                                    </div>
                                </div>                              
                                <div class="form-group">                                
                                    <label class="control-label col-lg-3">
                                        {l s='Client ID / klucz WebAPI' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-6">
                                        <input value="{$clientId}" name="clientId" type="text">
                                        <p class="help-block">
                                            {l s='Client ID.' mod='psoft_allegro'}
                                        </p>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                        {l s='Client secret' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-6">
                                        <input value="{$clientSecret}" name="clientSecret" type="text">
                                        <p class="help-block">
                                            {l s='Client secret.' mod='psoft_allegro'}
                                        </p>
                                    </div>
                                </div>
                                <div class="panel-footer">
                                    <button type="submit" value="1" id="module_form_submit_btn" name="setAllegroSecret" class="btn btn-default pull-right">
                                        <i class="process-icon-save"></i>{l s='Save' mod='psoft_allegro'}
                                    </button>
                                </div>
                            </div>
                        </form>
                        {if !$access_token && $clientId && $clientSecret}    
                            <div class="panel">
                                <div class="panel-heading">{l s='Operacje' mod='psoft_allegro'}</div>                            
                                <div class="allegro-button-row">                    
                                    <form action="" method="post" enctype="multipart/form-data" novalidate="">
                                        <button type='submit' class="allegro-btn" name='getToken'>{l s='Zaloguj' mod='psoft_allegro'}</button>
                                    </form>
                                </div>
                            </div>
                        {/if}
                        {if $access_token}    
                            <div class="panel">
                                <div class="panel-heading">{l s='Operacje' mod='psoft_allegro'}</div>                            
                                <div class="allegro-button-row">    
                                    <form action="" method="post" enctype="multipart/form-data" novalidate="">
                                        <button type='submit' class="allegro-btn" name='importOffers'>{l s='Importuj aukcję oraz kategorię' mod='psoft_allegro'}</button>
                                    </form>
                                    <form action="" method="post" enctype="multipart/form-data" novalidate="">
                                        <button type='submit' class="allegro-btn" name='refreshToken'>{l s='Odśwież token' mod='psoft_allegro'}</button>
                                    </form>
                                    <form action="" method="post" enctype="multipart/form-data" novalidate="">
                                        <button type='submit' class="allegro-btn" name='logOutAllegro'>{l s='Wyloguj' mod='psoft_allegro'}</button>
                                    </form>
                                </div>
                            </div>
                            <form id="module_form" class="defaultForm form-horizontal" action="" method="post" enctype="multipart/form-data" novalidate="">
                                <div class="panel">
                                    <div class="panel-heading">{l s='Ustawienia' mod='psoft_allegro'}</div>
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                                {l s='Grupuj produkty na podstawie symbol aukcji' mod='psoft_allegro'}
                                            </label>
                                            <div class="col-lg-9">
                                                <span class="switch prestashop-switch fixed-width-lg">
                                                    <input name="block_option_1" id="block_option_1_on" value="1" {if $groupProductsBy == '1'}checked="checked"{/if} type="radio">
                                                    <label for="block_option_1_on">{l s='Tak' mod='psoft_allegro'}</label>
                                                    <input name="block_option_1" id="block_option_1_off" value="0" {if $groupProductsBy == '0'}checked="checked"{/if} type="radio">
                                                    <label for="block_option_1_off">{l s='Nie' mod='psoft_allegro'}</label>
                                                    <a class="slide-button btn"></a>
                                                </span>
                                                <p class="help-block">
                                                    {l s='W symbolu aukcji musi znaleźć się znak "-" żeby system powiązał podobne aukcje ze sobą.' mod='psoft_allegro'}                                               
                                                </p>
                                            </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='Nowe atrybuty/cechy importuj używając' mod='psoft_allegro'}
                                        </label>
                                        <div class="col-lg-6">
                                            <select name="featureSize" class="fixed-width" id="featureSize">                    
                                                <option value="1" {if $featureSize == '1'}selected{/if}>{l s='WIELKICH ZNAKÓW' mod='psoft_allegro'}</option>
                                                <option value="2" {if $featureSize == '2'}selected{/if}>{l s='małych znaków' mod='psoft_allegro'}</option>
                                            </select>
                                            <p class="help-block">
                                                {l s='Nowe atrybuty, cechy w sklepie będą tworzone z uwzględnieniem wielkich bądź mały liter.' mod='psoft_allegro'}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='Opis aukcji/opis produktu' mod='psoft_allegro'}
                                        </label>
                                        <div class="col-lg-6">
                                            <select name="description" class="fixed-width" id="description">                    
                                                <option value="1" {if $description == '1'}selected{/if}>{l s='Zachowuj format Allegro' mod='psoft_allegro'}</option>
                                                <option value="2" {if $description == '2'}selected{/if}>{l s='Tylko tekst' mod='psoft_allegro'}</option>
                                            </select>
                                            <p class="help-block">
                                                {l s='Czy produkty mają wyświetlać opis w stylu portalu Allegro, czy bez zdjęć.' mod='psoft_allegro'}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='Dodaj wszystkie produkty do kategorii' mod='psoft_allegro'}
                                        </label>
                                        <div class="col-lg-6">
                                            <select name="categoriesShop" class="fixed-width" id="categoriesShop">                    
                                                <option value="0">{l s='Wybierz' mod='psoft_allegro'}</option>
                                                {foreach $getCategoriesShop AS $c}
                                                    <option value="{$c['id_category']}" {if {$c['id_category']}==$selectedCategoriesShop}selected{/if}>{if $c['parent']}{$c['parent']} > {/if}{$c['name']}</option>
                                                {/foreach}                                                
                                            </select>
                                            <p class="help-block">
                                                {l s='Wybrana kategoria zostanie dodana do każdego produktu.' mod='psoft_allegro'}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="control-label col-lg-3">
                                            {l s='Dodaj kolor do produktów' mod='psoft_allegro'}
                                        </label>
                                        <div class="col-lg-6">
                                            <select name="colorsShop" class="fixed-width" id="colorsShop">                    
                                                <option value="0">{l s='Wybierz' mod='psoft_allegro'}</option>
                                                {foreach $getAllColors AS $color}
                                                    <option value="{$color['id_attribute']}" {if {$color['id_attribute']}==$selectedColor}selected{/if}>{$color['name']}</option>
                                                {/foreach}                                                
                                            </select>
                                            <p class="help-block">{l s='Nie wszystkie kategorie w Allegro pozwalają na zdefiniowanie koloru w aukcji. Powyższa opcja pozwala dodać flagę (czy. domyślny kolor) do produktów, które mają odpowiedni symbol produktu, ale Allegro nie pozwala na przypisanie koloru.' mod='psoft_allegro'}                                               
                                            </p>
                                        </div>
                                    </div>
                                    <div class="panel-footer">
                                        <button type="submit" value="1" id="module_form_submit_btn" name="setAllegroSettings" class="btn btn-default pull-right">
                                            <i class="process-icon-save"></i>{l s='Save' mod='psoft_allegro'}
                                        </button>
                                    </div>
                                </div>
                            </form>
                            <div class="panel">
                                <div class="panel-heading">{l s='Automatyczny import aukcji' mod='psoft_allegro'}</div>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                            {l s='URL' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-9">
                                        {$cronImport}
                                        <p class="help-block">{l s='Powyższy adres URL należy dodać do harmonogramu zadań (z ang. CRON) poprzez panel administracyjny serwera.' mod='psoft_allegro'}                                               
                                    </p>
                                    </div>
                                </div> 
                                <div class="panel-footer">
                                </div>                             
                            </div>
                            <div class="panel">
                                <div class="panel-heading">{l s='Automatyczna aktualizacja cen, ilości' mod='psoft_allegro'}</div>
                                <div class="form-group">
                                    <label class="control-label col-lg-3">
                                            {l s='URL' mod='psoft_allegro'}
                                    </label>
                                    <div class="col-lg-9">
                                        {$cronUpdate}
                                        <p class="help-block">{l s='Powyższy adres URL należy dodać do harmonogramu zadań (z ang. CRON) poprzez panel administracyjny serwera.' mod='psoft_allegro'}                                               
                                    </p>
                                    </div>
                                </div> 
                                <div class="panel-footer">
                                </div>                             
                            </div>
                        {/if}                   
                    </div>
                </div>              

                <div class="tab-pane" id="author">
                    <div class="tab-content">
                        <div class="panel">
                            <div class="panel-heading">{l s='Author' mod='psoft_allegro'}</div>
                            <img src="https://www.suszek.info/prestashop_modules/PSoft%20-%20Przemys%C5%82aw%20Suszek.png"
                                alt="PSoft - Przemysław Suszek">
                            <p><a href="tel:48603816259">+48 603 816 259</a></p>
                            <p>kontakt@suszek.info</p>
                            <p><a href="https://www.suszek.info" target="_blank">http://www.suszek.info</a></p>
                        </div>
                        <div class="panel">
                            <div class="panel-heading">{l s='Social media' mod='psoft_allegro'}</div>
                            <a href="https://www.facebook.com/PSoft-Przemys%C5%82aw-Suszek-208711446265703/"
                                target="_blank"><img src="https://www.suszek.info/prestashop_modules/Facebook-logo.png"
                                    alt="PSoft - Przemysław Suszek Facebook page"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $('#select-all-btn').change((e)=>{
            $('#select-row-checkbox input[type="checkbox"]').prop('checked', e.target.checked);
        })
    </script>