{*
/**
*
* @author PSoft - Przemysław Suszek <kontakt@suszek.info>
* @copyright PSoft - Przemysław Suszek
* @license This program is not free software and you can't resell and redistribute it
* @category PrestaShop Module
*
*/
*}
<style>
    .w100{
        width:100%;
        display:inline;
    }
    .mb-4 {
        margin-bottom: 15px;
    }

    .allegro-btn {
        background-color: #ff5a00 !important;
        border-color: #ff5a00 !important;
        color: #fff !important;
    }

    .allegro-btn:hover {
        background-color: #ff7b33 !important;
    }

    .allegro-btn > i{
        color: #fff !important;
    }

    .importButton{
        margin-right: 15px;
    }
</style>
<div class="tab-pane">
    <div class="tab-content">
        <div class="panel">
            <div class="panel-heading">{l s='Powiązanie kategorii' mod='psoft_allegro'}</div>
            <div class="alert alert-message">
                <p>{l s='W tym miejscu mogą Państwo utworzyć powiązanie pomiędzy kategorią na platformie Allegro a kategorią dostępną w sklepie. Podczas tworzenia produktu zostanie sprawdzona kategoria z Allegro a następnie produkt zostanie przypisany do zdefiniowanej kategorii przez użytkownika w sklepie.' mod='psoft_allegro'}</p>
            </div>

            <form action="" method="post" enctype="multipart/form-data" novalidate="">
            {if is_object($mapCategoriesList)}
                <div class="row mb-4">
                    <input type="file" name="fileToUpload" id="fileToUpload">
                    <button type="submit" value="1" id="module_form_submit_btn" name="exportCategories" class="btn btn-default pull-right allegro-btn">
                        {l s='Export' mod='psoft_allegro'}
                    </button>
                    <button type="submit" value="1" id="module_form_submit_btn" name="importCategories" class="btn btn-default pull-right allegro-btn importButton">
                        {l s='Import' mod='psoft_allegro'}
                    </button>
                </div>
                {foreach $mapCategoriesList->allegro AS $allegroCategory}
                <div class="row mb-4">
                    <div id="{$allegroCategory->allegro_id}" class="col-xs-6">
                        {$allegroCategory->allegro_name}
                    </div>
                    <div class="col-xs-6">
                        <select name='categoryID[{$allegroCategory->allegro_id}]'>
                        <option value=0>Wybierz</option>
                            {foreach $mapCategoriesList->presta AS $prestaCategory}
                            <option value="{$prestaCategory->id_category}" {if $prestaCategory->
                                id_category==$allegroCategory->presta_id}selected{/if}>{if $prestaCategory->parent}{$prestaCategory->parent} > {/if}{$prestaCategory->name}
                            </option>
                            {/foreach}
                        </select>
                    </div>
                </div>
                {/foreach}
                <div class="panel-footer">
                    <button type="submit" value="1" id="module_form_submit_btn" name="saveCategoriesMap" class="btn btn-default pull-right allegro-btn">
                        <i class="process-icon-save"></i>{l s='Save' mod='psoft_allegro'}
                    </button>
                </div>
                {/if}
            </form>
        </div>
    </div>
</div>