{*
/**
*
* @author PSoft - Przemysław Suszek <kontakt@suszek.info>
    * @copyright PSoft - Przemysław Suszek
    * @license This program is not free software and you can't resell and redistribute it
    * @category PrestaShop Module
    *
    */
    *}
    <style>
        .w100{
            width:100%;
            display:inline;
        }
        .mb-4 {
            margin-bottom: 15px;
        }

        .allegro-btn {
            color: #fff;
            background: #ff5a00;
            letter-spacing: 2px;
            font-weight: 500;
            text-transform: uppercase;
            border: 0;
            text-align: center;
            padding: 10px;
        }

        .allegro-btn:hover {
            background: #ff7b33;
        }

        .allegro-button-row{
            display:flex;
        }

        .allegro-button-row button{
            margin:5px 5px 5px 0px;
        }

        .searchBar{
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr 1fr 6fr;
            column-gap: 25px;
            height: 50px;
        }

        .searchBar input[type="text"]{
            height: 50px;
        }

        .searchBar input[type="checkbox"]{
            height: 30px;
            width: 30px;
            margin-top: 9px;
        }

        .searchBar > div{
            display: flex;
        }

        .searchBar > div > p{
            margin: 17px 0px 0px 10px;
        }

        .bootstrap .pagination > li:first-child > a, .bootstrap .pagination > li:first-child > span {
            border-bottom-left-radius: 0px;
            border-top-left-radius: 0px;
            margin-left: -1px;
        }

        .bootstrap .pagination > li > a, .bootstrap .pagination > li > span {
            text-align: center;
            width: 56px;
        }

        .table-responsive{
            margin: 25px 0px 25px 0px;
        }

        .table-responsive tr{
            height: 40px;
        }
        
        .table-responsive thead{
            font-size: 14px;
            background: #ff5a00;
            color: #fff;
        }

        li.page-item a.active{
            background-color: #ff9c66;
            color: #fff;
        }
        
    </style>
    <div class="tab-pane">
        <div class="tab-content">
            <form id="module_form" class="defaultForm form-horizontal" action="" method="post" enctype="multipart/form-data" novalidate="">
                <div class="panel">
                    <div class="panel-heading">{l s='Aukcje' mod='psoft_allegro'}</div>                            
                    <div class="form-group">
                        {if !$access_token || !$clientId || !$clientSecret}
                            <div class="alert alert-info">
                                {l s='Przed pierwszym użyciem należy skonfigurować moduł. W tym celu proszę zapoznać się z instrukcją obsługi, która dostępna jest po lewej stronie.' mod='psoft_allegro'}
                            </div>
                        {/if}

                        {if is_object($mapCategoriesList)}
                            {if $mapCategoriesList->done == ''}
                                <div class="alert alert-info">
                                    {l s='Proszę powiązać kategorię' mod='psoft_allegro'}
                                </div>
                            {/if}
                        {/if}
                    </div>

                    {if is_object($mapCategoriesList)}
                        {if $mapCategoriesList->done }
                            <div class="searchBar">
                                <form action="" method="post" enctype="multipart/form-data" novalidate="">
                                    <input type="text" name="filter-query[symbol]" value='{if isset($filter['symbol'])}{$filter['symbol']}{else}{/if}' placeholder="{l s='Wprowadź symbol produktu' mod='psoft_allegro'}">
                                    
                                    <div>
                                        <input type="radio" name="filter-query[]" value="new" {if in_array('new',$filter)}checked{/if}><p>{l s='Nowe' mod='psoft_allegro'}</p>                                    
                                    </div>
                                    <div>
                                        <input type="radio" name="filter-query[]" value="skip" {if in_array('skip',$filter)}checked{/if}><p>{l s='Pominięte' mod='psoft_allegro'}</p>
                                    </div>
                                    <div>
                                        <input type="radio" name="filter-query[]" value="imported" {if in_array('imported',$filter)}checked{/if}><p>{l s='Zaimportowane' mod='psoft_allegro'}</p>
                                    </div>
                                    
                                    <button type='submit' class="allegro-btn" name='searchAuctions'>{l s='Szukaj' mod='psoft_allegro'}</button>
                                </form>
                            </div>
                            {if $offers}
                                <form action="" method="post" enctype="multipart/form-data" novalidate="">

                                    <nav>
                                        <ul class="pagination">
                                            {for $pagenum = 1 to $countPage}                                 
                                                <li class="page-item"><a class="{if $selectedPage == $pagenum}active{/if}" href="{$customUrl}&page={$pagenum}">{$pagenum}</a></li>
                                            {/for}
                                        </ul>
                                    </nav>

                                    <div class="allegro-button-row">
                                        <button type='submit' class="allegro-btn" name='autoCreateProduct'>{l s='Szybkie tworzenie produktów' mod='psoft_allegro'}</button>
                                        <button type='submit' class="allegro-btn" name='skipProducts'>{l s='Pomiń' mod='psoft_allegro'}</button>
                                    </div> 

                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th scope="col"><input type='checkbox' id='select-all-btn'></th>
                                                    <th scope="col">{l s='Lp.' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Numer aukcji' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Symbol' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Nazwa aukcji' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='ID produktu' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Nazwa produktu w sklepie' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Status' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Status aukcji Allegro' mod='psoft_allegro'}</th>
                                                    <th scope="col">{l s='Pomiń' mod='psoft_allegro'}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {if !empty($smarty.get.page)}
                                                    {$iterator=(($smarty.get.page-1)*30)+1}
                                                {else}
                                                    {$iterator=1}
                                                {/if}
                                                {foreach $offers AS $offer}
                                                <tr>
                                                    <td scope="row" id="select-row-checkbox">{if $offer->imported == '0' && $offer->skip == "0"}<input type='checkbox'
                                                            name="checked_auction[]" value='{$offer->id}'>{else}{/if}</td>
                                                    <td>{$iterator++}</td>
                                                    <td><a href="{$envURL}/oferta/{$offer->id}" target="_blank">{$offer->id}</a></td>                    
                                                    <td>{$offer->symbol}</td>                    
                                                    <td><a href="{$envURL}/oferta/{$offer->id}" target="_blank">{$offer->name}</a></td>                                                    
                                                    <td>{$offer->presta_product_id}</td>
                                                    <td>{$offer->presta_name}</td>
                                                    <td>{if $offer->imported == '0'}{else}{l s='Zaimportowano' mod='psoft_allegro'}{/if}</td>
                                                    <td>{if $offer->active == '1'}{l s='Aktywna' mod='psoft_allegro'}{else}{l s='Zakończona' mod='psoft_allegro'}{/if}</td>
                                                    <td>
                                                        {if $offer->skip == '1'}
                                                            <button type='submit' class="allegro-btn" name='removeSkipProduct' value='{$offer->id}'>{l s='Przywróć' mod='psoft_allegro'}</button>
                                                        {else}
                                                        {/if}
                                                    </td>
                                                </tr>
                                                {/foreach}
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- <button type='submit' class="allegro-btn" name='createProduct_step_1'>{l s='Stwórz produkty' mod='psoft_allegro'}</button> -->
                                    <button type='submit' class="allegro-btn" name='autoCreateProduct'>{l s='Szybkie tworzenie produktów' mod='psoft_allegro'}</button>
                                    <button type='submit' class="allegro-btn" name='skipProducts'>{l s='Pomiń' mod='psoft_allegro'}</button>

                                </form>

                                <nav>
                                    <ul class="pagination">
                                        {for $pagenum = 1 to $countPage}                                 
                                            <li class="page-item"><a class="{if $selectedPage == $pagenum}active{/if}" href="{$customUrl}&page={$pagenum}">{$pagenum}</a></li>
                                        {/for}
                                    </ul>
                                </nav>

                            {/if}                                
                        {/if}
                    {/if}
                </div>
            </form>
        </div>
    </div>              

    <script>
        $('#select-all-btn').change((e)=>{
            $('#select-row-checkbox input[type="checkbox"]').prop('checked', e.target.checked);
        })
    </script>