<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */
ini_set('max_execution_time', 0);
if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(dirname(__FILE__) . '/core/psoftAllegroCore.php');

class psoft_allegro extends psoftAllegroCore
{
    public function __construct()
    {
        $this->name = 'psoft_allegro';
        $this->tab = 'administration';
        $this->version = '1.1.24';
        $this->author = 'PSoft - Przemysław Suszek | kontakt@suszek.info | www.suszek.info';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => '1.7');
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Allegro');
        $this->description = $this->l('Module allow you to create products from your auctions in Allegro platform.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
    }

    public function install()
    {
        $idShopGroup = (int)Context::getContext()->shop->getContextShopGroupID();
        $idShop = (int)Context::getContext()->shop->id;

        return parent::install() &&
            $this->registerHook('actionProductDelete') &&
            $this->registerHook('actionAdminControllerSetMedia') &&
            $this->registerHook('actionFrontControllerSetMedia') &&
            $this->installTab() &&
            Db::getInstance()->execute('CREATE TABLE ' . _DB_PREFIX_ . 'psoft_allegro ( `id` VARCHAR(20) NOT NULL , `symbol` VARCHAR(20) NOT NULL , `name` VARCHAR(50) NOT NULL , `category` VARCHAR(50) NOT NULL , `price` FLOAT NOT NULL , `count` INT NOT NULL ,`presta_product_id` INT(10) NOT NULL, `presta_name` VARCHAR(50) NOT NULL , `imported` BOOLEAN NOT NULL , `skip` BOOLEAN NOT NULL , `active` BOOLEAN NOT NULL , combinations INT(1) , date_update DATETIME DEFAULT CURRENT_TIMESTAMP ,  PRIMARY KEY (`id`)) CHARSET=utf8 COLLATE=utf8_unicode_ci') &&
            Db::getInstance()->execute('CREATE TABLE ' . _DB_PREFIX_ . 'psoft_allegro_configuration (`id` INT AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(254), `value` LONGTEXT) CHARSET=utf8 COLLATE=UTF8_UNICODE_CI') &&
            Db::getInstance()->execute('CREATE TABLE ' . _DB_PREFIX_ . 'psoft_allegro_category_map ( `allegro_id` VARCHAR(10) NOT NULL , `allegro_name` VARCHAR(150) NOT NULL , `presta_id` VARCHAR(10) , PRIMARY KEY (`allegro_id`)) CHARSET=utf8 COLLATE=utf8_unicode_ci') &&
            Db::getInstance()->execute('INSERT INTO ' . _DB_PREFIX_ . 'psoft_allegro_configuration (`id`, `name`, `value`) VALUES (1, "MAP_CATEGORIES", "" )') &&
            Configuration::updateValue('PSOFT_ALLEGRO_LICENSE_ID', 'psoft_62e6d8f5451e8', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_ACCESS_TOKEN', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_REFRESH_TOKEN', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_RETURN_URL', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_OFFERS', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_ID', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_CLIENT_SECRET', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_ID_TO_CREATE', '', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_GROUP_PRODUCTS', 1, $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_FEATURESIZE', 1, $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_DESCRIPTION', 1, $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_CATEGORIES', '0', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_COLOR', '0', $html = false, $idShopGroup, $idShop) &&
            Configuration::updateValue('PSOFT_ALLEGRO_SELECTED_ENVIRONMENT', '0', $html = false, $idShopGroup, $idShop);
    }

    public function uninstall()
    {
        return parent::uninstall() &&
            Db::getInstance()->execute('DROP TABLE ' . _DB_PREFIX_ . 'psoft_allegro') &&
            Db::getInstance()->execute('DROP TABLE ' . _DB_PREFIX_ . 'psoft_allegro_configuration') &&
            Db::getInstance()->execute('DROP TABLE ' . _DB_PREFIX_ . 'psoft_allegro_category_map') &&
            $this->uninstallTab() &&
            Configuration::deleteByName('PSOFT_ALLEGRO_LICENSE_ID') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_ACCESS_TOKEN') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_REFRESH_TOKEN') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_RETURN_URL') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_OFFERS') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_CLIENT_ID') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_CLIENT_SECRET') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_ID_TO_CREATE') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_GROUP_PRODUCTS') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_FEATURESIZE') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_DESCRIPTION') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_SELECTED_CATEGORIES') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_SELECTED_COLOR') &&
            Configuration::deleteByName('PSOFT_ALLEGRO_SELECTED_ENVIRONMENT');
    }

    private function installTab()
    {
        $tabs = $this->createTab('Allegro', 'psoftAllegro', null);
        $tabs &= $this->createTab('Aukcje', 'psoftAllegroAuctions', 'psoftAllegro');
        $tabs &= $this->createTab('Mapowanie kategorii', 'psoftAllegroCat', 'psoftAllegro');
        $tabs &= $this->createTab('Ustawienia', 'psoftAllegroConfiguration', 'psoftAllegro');
        $tabs &= $this->createTab('Instrukcja', 'psoftAllegroManual', 'psoftAllegro');
        $tabs &= $this->createTab('Dziennik zdarzeń', 'psoftAllegroLog', 'psoftAllegro');

        return $tabs;
    }

    private function createTab($name, $className, $parent)
    {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = $className;
        $tab->name = array();
        foreach (Language::getLanguages(false) as $lang) {
            $tab->name[$lang['id_lang']] = $name;
        }

        if ($parent != null) {
            $tab->id_parent = (int) Tab::getIdFromClassName($parent);
        } else {
            $tab->id_parent = 0;
        }
        $tab->module = $this->name;
        return $tab->add();
    }

    private function deleteTab($name)
    {
        $id_tab = (int) Tab::getIdFromClassName($name);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            return $tab->delete();
        } else {
            return false;
        }
        return true;
    }

    private function uninstallTab()
    {
        return
            $this->deleteTab('psoftAllegro') &&
            $this->deleteTab('psoftAllegroCat') &&
            $this->deleteTab('psoftAllegroAuctions') &&
            $this->deleteTab('psoftAllegroConfiguration') &&
            $this->deleteTab('psoftAllegroManual');
        $this->deleteTab('psoftAllegroLog');
    }

    public function getContent()
    {
        Tools::redirectAdmin($this->context->link->getAdminLink('psoftAllegroConfiguration'));
    }

    public function hookActionProductDelete($params)
    {
        $this->afterDeleteProduct($params['product']->id);
    }

    public function hookActionAdminControllerSetMedia()
    {
        $this->context->controller->addCss($this->_path . 'views/css/tail.select-default.css');
        $this->context->controller->addJs($this->_path . 'views/js/tail.select.min.js');
    }

    public function hookActionFrontControllerSetMedia()
    {
        if (Tools::getValue('controller') == 'product') {
            $this->context->controller->addCss($this->_path . 'views/css/psoft_allegro_front.css');
        }
    }
}
