<?php

/**
 *
 * @author      PSoft - Przemysław Suszek <kontakt@suszek.info>
 * @copyright   PSoft - Przemysław Suszek
 * @license     This program is not free software and you can't resell and redistribute it
 * @category    PrestaShop Module
 *
 */

require_once(dirname(__FILE__) . '/../../core/psoftAllegroCore.php');

class psoftAllegroManualController extends ModuleAdminController
{
    public function __construct()
    {
        $this->bootstrap = true;
        $this->lang = true;
        $this->allow_export = false;
        $this->psoftAllegroCore = new psoftAllegroCore();
        parent::__construct();
    }

    public function init()
    {
        parent::init();
    }

    public function initContent()
    {
        $this->display = 'view';
        parent::initContent();
    }

    public function renderView()
    {
        $env = $this->psoftAllegroCore->setEnvironment();
        $this->context->smarty->assign(array(
            'envURL' => $env->apps,
            'url' => _PS_BASE_URL_SSL_ . '/modules/psoft_allegro/oAuth/code.php',
        ));
        return $this->context->smarty->fetch(_PS_MODULE_DIR_ . 'psoft_allegro/views/templates/admin/manual.tpl');
    }
}
